package org.Vrglab.Modloader.CreationHelpers;

import net.minecraft.class_5450;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.world.gen.placementmodifier.*;
import org.Vrglab.Modloader.Types.ICallBack;
import org.Vrglab.Utils.VLModInfo;

import java.util.ArrayList;
import java.util.List;

public class PlacementModifierCreationHelper {
    private List<class_6797> targets;
    public static ICallBack getHeightModifications;

    private PlacementModifierCreationHelper() {
    }

    public static PlacementModifierCreationHelper create() {
        PlacementModifierCreationHelper gen = new PlacementModifierCreationHelper();
        gen.targets = new ArrayList<>(4);
        gen.targets.add(0, null);
        gen.targets.add(1, class_5450.method_39639());
        gen.targets.add(2, null);
        gen.targets.add(3, class_6792.method_39614());
        return gen;
    }

    public PlacementModifierCreationHelper HeightRangePlacement(int lowest, int highest) {
        targets.set(2, (class_6797)getHeightModifications.accept(lowest, highest));
        return this;
    }

    public PlacementModifierCreationHelper CountModifier(int count) {
        if(targets.get(0)!= null && targets.get(0).getClass() == class_6799.class) {
            VLModInfo.LOGGER.error("Cant add Count modifier when Rarity modifier is already added");
            return this;
        }

        targets.set(0, class_6793.method_39623(count));
        return this;
    }

    public PlacementModifierCreationHelper RarityModifier(int chance) {
        if(targets.get(0)!= null && targets.get(0).getClass() == class_6793.class) {
            VLModInfo.LOGGER.error("Cant add Rarity modifier when Count modifier is already added");
            return this;
        }

        targets.set(0, class_6799.method_39659(chance));
        return this;
    }

    public List<class_6797> build(){
        return targets;
    }
}
