package org.Vrglab.fabric;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2405;
import net.minecraft.class_7877;
import org.Vrglab.Utils.VLModInfo;
import org.Vrglab.fabriclike.Utils.FabricLikeRegisteryCreator;

public class VLDataGenerator implements DataGeneratorEntrypoint {
    /**
     * Register {@link class_2405} with the {@link FabricDataGenerator} during this entrypoint.
     *
     * @param fabricDataGenerator The {@link FabricDataGenerator} instance
     */
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(VLWorldGen::new);
    }

    /**
     * Builds a registry containing dynamic registry entries to be generated.
     * Users should call {@link class_7877#method_46777(net.minecraft.class_5321, class_7877.class_7882)}
     * to register a bootstrap function, which adds registry entries to be generated.
     *
     * <p>This is invoked asynchronously.
     *
     * @param registryBuilder a {@link class_7877} instance
     */
    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        FabricLikeRegisteryCreator.boostrap(registryBuilder, VLModInfo.MOD_ID);
    }
}
