package org.Vrglab.fabriclike.Utils;

import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.villager.VillagerProfessionBuilder;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5843;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import net.minecraft.world.gen.feature.*;
import org.Vrglab.EnergySystem.EnergyStorage;
import org.Vrglab.EnergySystem.EnergyStorageUtils;
import org.Vrglab.EnergySystem.IEnergySupplier;
import org.Vrglab.Modloader.CreationHelpers.OreGenFeatCreationHelper;
import org.Vrglab.Modloader.CreationHelpers.PlacementModifierCreationHelper;
import org.Vrglab.Modloader.CreationHelpers.TypeTransformer;
import org.Vrglab.Modloader.Registration.Registry;
import org.Vrglab.Modloader.Types.*;
import org.Vrglab.Modloader.enumTypes.RegistryTypes;
import org.Vrglab.Modloader.enumTypes.VinillaBiomeTypes;
import org.Vrglab.Networking.Network;
import team.reborn.energy.api.base.SimpleEnergyStorage;

import java.util.List;
import java.util.function.Supplier;

public class FabricLikeRegisteryCreator {

    public static void Create(String modid) {

        setEnergyStorageStatics(modid);

        OreGenFeatCreationHelper.ObjectBlockToStateConverted = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return ((class_2248)args[0]).method_9564();
            }
        };

        PlacementModifierCreationHelper.getHeightModifications = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return class_6795.method_39637(class_5843.method_33846((Integer) args[0]), class_5843.method_33846((Integer) args[1]));
            }
        };


        TypeTransformer.ObjectToType = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return args[0];
            }
        };

        Network.registerGlobalReceiver = new ICallbackVoid() {
            @Override
            public void accept(Object... args) {
                ServerPlayNetworking.registerGlobalReceiver((class_2960) args[0], (a,b,c,d,e)->((ICallBack)args[1]).accept(a,b,c,d,e));
            }
        };

        Network.clientSendPacket = new ICallbackVoid() {
            @Override
            public void accept(Object... args) {
                ClientPlayNetworking.send((class_2960) args[0], (class_2540) args[1]);
            }
        };

        ICallBack ItemRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_11142, new class_2960(modid, args[0].toString()), ((Supplier<class_1792>)args[1]).get());
            }
        };

        ICallBack BlockRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                class_2248 b = net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_11146, new class_2960(modid, args[0].toString()), ((Supplier<class_2248>)args[1]).get());
                net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_11142, new class_2960(modid, args[0].toString()), new class_1747(b, (class_1792.class_1793) args[2]));
                return b;
            }
        };

        ICallBack ItemlessBlockRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_11146, new class_2960(modid, args[0].toString()), ((Supplier<class_2248>)args[1]).get());
            }
        };

        ICallBack POIRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return PointOfInterestHelper.register(new class_2960(modid, args[0].toString()), (int)args[1], (int)args[2], (class_2248)args[3]);
            }
        };

        ICallBack ProfesionRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_17167, new class_2960(modid, args[0].toString()), VillagerProfessionBuilder.create().id(new class_2960(modid, args[0].toString())).workstation(class_5321.method_29179(net.minecraft.class_2378.field_25090, new class_2960(modid, args[1].toString()))).harvestableItems(args[2] == null ? null: (class_1792[])args[2]).secondaryJobSites(args[3] == null ? null: (class_2248[])args[3]).workSound((args.length >= 5 && args[4] == null) ? null : (class_3414)args[4]).build());
            }
        };

        ICallBack TradeRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                TradeOfferHelper.registerVillagerOffers((class_3852)args[1] ,(int)args[2],
                        factories -> {
                            for (class_1914 data: (class_1914[])args[3]) {
                                factories.add(((entity, random) -> data));
                            }
                        });
                return null;
            }
        };

        ICallBack OreGenRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return class_6803.method_39708(args[0].toString(), (class_3031) args[1], new class_3124(((Supplier<List<class_3124.class_5876>>) args[2]).get(), (int)args[3]));
            }
        };

        ICallBack PlacedFeatCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return class_6817.method_39737(args[0].toString(), (class_6880<? extends class_2975<?, ?>>) args[1], (List<class_6797>) args[2]);
            }
        };

        ICallBack BiomeModCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                VinillaBiomeTypes types = (VinillaBiomeTypes) args[1];
                switch (types){
                    case END -> BiomeModifications.addFeature(BiomeSelectors.foundInTheEnd(), (class_2893.class_2895) args[2], ((class_6880<class_6796>) args[3]).method_40230().get());
                    case NETHER -> BiomeModifications.addFeature(BiomeSelectors.foundInTheNether(), (class_2893.class_2895) args[2], ((class_6880<class_6796>) args[3]).method_40230().get());
                    case OVERWORLD -> BiomeModifications.addFeature(BiomeSelectors.foundInOverworld(), (class_2893.class_2895) args[2], ((class_6880<class_6796>) args[3]).method_40230().get());
                }
                return null;
            }
        };

        ICallBack BlockEntityTypeRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                FabricBlockEntityTypeBuilder.Factory factory = new FabricBlockEntityTypeBuilder.Factory() {
                    @Override
                    public class_2586 create(class_2338 blockPos, class_2680 blockState) {
                        return ((IBlockEntityLoaderFunction)args[1]).create(blockPos, blockState);
                    }
                };
                return net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_11137, new class_2960(modid, args[0].toString()), FabricBlockEntityTypeBuilder.create(factory, (class_2248)args[2]).build());
            }
        };


        ICallBack ScreenHandlerTypeRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                class_3917.class_3918 factory = new class_3917.class_3918() {
                    @Override
                    public class_1703 create(int syncId, class_1661 playerInventory) {
                        return ((IScreenHandlerTypeCreationFunction)args[1]).create(syncId, playerInventory);
                    }
                };
                return new class_3917<>(factory);
            }
        };

        ICallBack RecipeSerializerRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_17598, new class_2960(modid, args[0].toString()), (class_1865)args[1]);
            }
        };

        ICallBack RecipeTypeRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return net.minecraft.class_2378.method_10230(net.minecraft.class_2378.field_17597, new class_2960(modid, args[0].toString()), (class_3956) args[1]);
            }
        };


        Registry.initRegistry(ItemRegistryCallBack, RegistryTypes.ITEM, modid);
        Registry.initRegistry(ItemlessBlockRegistryCallBack, RegistryTypes.ITEMLESS_BLOCK, modid);
        Registry.initRegistry(BlockRegistryCallBack, RegistryTypes.BLOCK, modid);
        Registry.initRegistry(BlockEntityTypeRegistryCallBack, RegistryTypes.BLOCK_ENTITY_TYPE, modid);
        Registry.initRegistry(ScreenHandlerTypeRegistryCallBack, RegistryTypes.SCREEN_HANDLER_TYPE, modid);
        Registry.initRegistry(POIRegistryCallBack, RegistryTypes.POI, modid);
        Registry.initRegistry(ProfesionRegistryCallBack, RegistryTypes.PROFESSION, modid);
        Registry.initRegistry(TradeRegistryCallBack, RegistryTypes.TRADE, modid);
        Registry.initRegistry(OreGenRegistryCallBack, RegistryTypes.CONFIGURED_FEAT_ORE, modid);
        Registry.initRegistry(PlacedFeatCallBack, RegistryTypes.PLACED_FEAT, modid);
        Registry.initRegistry(BiomeModCallBack, RegistryTypes.BIOME_MODIFICATIONS, modid);
        Registry.initRegistry(RecipeSerializerRegistryCallBack, RegistryTypes.RECIPE_SERIALIZER, modid);
        Registry.initRegistry(RecipeTypeRegistryCallBack, RegistryTypes.RECIPE_TYPE, modid);
    }

    public static void CreateClient(String modid){
        ICallBack HandledScreensRegistryCallBack = new ICallBack() {
            @Override
            public Object accept(Object... args) {

                class_3929.class_3930 provider = new class_3929.class_3930() {
                    @Override
                    public class_437 create(class_1703 handler, class_1661 playerInventory, class_2561 title) {
                        return ((IScreenHandledCreationFunction)args[2]).create((org.Vrglab.Screen.ScreenHandler) handler, playerInventory, title);
                    }
                };
                class_3929.method_17542((class_3917)args[1], provider);
                 return null;
            }
        };
        Registry.initRegistry(HandledScreensRegistryCallBack, RegistryTypes.HANDLED_SCREEN, modid);
    }


    private static void setEnergyStorageStatics(String modid) {
        EnergyStorageUtils.createStorageInstance = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                return new SimpleEnergyStorage((Long) args[0],(Long)  args[1],(Long)  args[2]){
                    @Override
                    protected void onFinalCommit() {
                        super.onFinalCommit();
                        try {
                            ((EnergyStorage)args[4]).makeDirty.accept();
                        } catch (Throwable t) {

                        }
                    }
                };
            }
        };

        EnergyStorageUtils.receiveEnergyInstance = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                try (Transaction openTrans = Transaction.openOuter()) {
                    long res = ((SimpleEnergyStorage)args[0]).insert((long)args[1], openTrans);
                    openTrans.commit();
                    return res;
                }
            }
        };

        EnergyStorageUtils.extractEnergyInstance = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                try (Transaction openTrans = Transaction.openOuter()) {
                    long res = ((SimpleEnergyStorage)args[0]).extract((long)args[1], openTrans);
                    openTrans.commit();
                    return res;
                }
            }
        };

        EnergyStorageUtils.hasExternalStorage = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                class_2586 entity = (class_2586) args[0];

                if(entity == null){
                    return false;
                }

                return (team.reborn.energy.api.EnergyStorage.SIDED.find(entity.method_10997(), entity.method_11016(), class_2350.field_11043) != null ||
                        team.reborn.energy.api.EnergyStorage.SIDED.find(entity.method_10997(), entity.method_11016(), class_2350.field_11034) != null ||
                        team.reborn.energy.api.EnergyStorage.SIDED.find(entity.method_10997(), entity.method_11016(), class_2350.field_11039) != null ||
                        team.reborn.energy.api.EnergyStorage.SIDED.find(entity.method_10997(), entity.method_11016(), class_2350.field_11035) != null);
            }
        };

        EnergyStorageUtils.wrapExternalStorage = new ICallBack() {
            @Override
            public Object accept(Object... args) {
                team.reborn.energy.api.EnergyStorage storage = team.reborn.energy.api.EnergyStorage.SIDED.find((class_1937) args[0], (class_2338) args[1], (class_2350) args[2]);
                return new EnergyStorage(storage, storage.getCapacity(), storage.getCapacity(), storage.getCapacity(), storage.getAmount());
            }
        };
    }
}
