/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.Modloader.Registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import org.Vrglab.Modloader.Types.IBlockEntityLoaderFunction;
import org.Vrglab.Modloader.Types.ICallBack;
import org.Vrglab.Modloader.Types.IScreenHandledCreationFunction;
import org.Vrglab.Modloader.Types.IScreenHandlerTypeCreationFunction;
import org.Vrglab.Modloader.enumTypes.RegistryTypes;
import org.Vrglab.Modloader.enumTypes.VinillaBiomeTypes;
import org.Vrglab.Screen.ScreenHandler;
import org.Vrglab.Utils.VLModInfo;

public class Registry {
    private static Map<String, Map<RegistryTypes, ICallBack>> open_registeries = new HashMap<String, Map<RegistryTypes, ICallBack>>();
    private static Map<String, Set<UnregisteredData>> ready_to_load_registeries = new HashMap<String, Set<UnregisteredData>>();

    public static void initRegistry(ICallBack _registery, RegistryTypes _currentRegistryTypes, String modid) {
        if (open_registeries.containsKey(modid)) {
            open_registeries.get(modid).put(_currentRegistryTypes, _registery);
        } else {
            open_registeries.put(modid, new HashMap());
            open_registeries.get(modid).put(_currentRegistryTypes, _registery);
        }
        if (ready_to_load_registeries.containsKey(modid) && ready_to_load_registeries.get(modid).size() > 0) {
            for (UnregisteredData data : ready_to_load_registeries.get(modid)) {
                if (data.resolved || data.registry_type != _currentRegistryTypes) continue;
                data.Obj = _registery.accept(data.args.toArray());
                data.resolved = true;
            }
        }
    }

    public static void ForgeEventResolver(Object eventData, ICallBack resolver, RegistryTypes ResolveTypeOf, String modid) {
        if (ready_to_load_registeries.containsKey(modid) && ready_to_load_registeries.get(modid).size() > 0) {
            for (UnregisteredData data : ready_to_load_registeries.get(modid)) {
                if (data.resolved || data.registry_type != ResolveTypeOf) continue;
                data.Obj = resolver.accept(data.args.toArray(), eventData);
            }
        }
    }

    public static Object RegisterItem(String name, String Modid, Supplier aNew) {
        return Registry.SimpleRegister(RegistryTypes.ITEM, Modid, name, aNew);
    }

    public static Object RegisterBlock(String name, String Modid, Supplier aNew, Item.Properties settings) {
        return Registry.SimpleRegister(RegistryTypes.BLOCK, Modid, name, aNew, settings);
    }

    public static Object RegisterBlockEntityType(String name, String Modid, IBlockEntityLoaderFunction aNew, Object block) {
        return Registry.SimpleRegister(RegistryTypes.BLOCK_ENTITY_TYPE, Modid, name, aNew, block);
    }

    public static Object RegisterScreenHandlerType(String name, String Modid, IScreenHandlerTypeCreationFunction aNew) {
        return Registry.SimpleRegister(RegistryTypes.SCREEN_HANDLER_TYPE, Modid, name, aNew);
    }

    public static <T extends ScreenHandler, U extends Screen> void RegisterHandledScreen(String name, String Modid, Object handlerType, IScreenHandledCreationFunction<T, U> aNew) {
        Registry.SimpleRegister(RegistryTypes.HANDLED_SCREEN, Modid, name, handlerType, aNew);
    }

    public static Object RegisterItemlessBlock(String name, String Modid, Supplier aNew) {
        return Registry.SimpleRegister(RegistryTypes.ITEMLESS_BLOCK, Modid, name, aNew);
    }

    public static Object RegisterPOI(String name, String Modid, Object block, int tickcount, int searchdistance) {
        return Registry.SimpleRegister(RegistryTypes.POI, Modid, name, tickcount, searchdistance, block);
    }

    public static Object RegisterProfession(String name, String Modid, String aNew, Item[] itemImmutableSet, Block[] blockImmutableSet, SoundEvent sound) {
        return Registry.SimpleRegister(RegistryTypes.PROFESSION, Modid, name, aNew, itemImmutableSet, blockImmutableSet, sound);
    }

    public static void RegisterVillagerTrade(String name, String Modid, Object profession, int level, MerchantOffer ... trades) {
        Registry.SimpleRegister(RegistryTypes.TRADE, Modid, name, profession, level, trades);
    }

    public static Object RegisterOreConfiguredFeature(String name, String Modid, Supplier<List<OreConfiguration.TargetBlockState>> targets, int size) {
        return Registry.SimpleRegister(RegistryTypes.CONFIGURED_FEAT_ORE, Modid, name, Feature.f_65731_, targets, size);
    }

    public static Object RegisterPlacedFeature(String name, String Modid, Object configured_feat, Object data) {
        return Registry.SimpleRegister(RegistryTypes.PLACED_FEAT, Modid, name, configured_feat, data);
    }

    public static void AddBiomeModification(String name, String Modid, VinillaBiomeTypes biomeTypes, GenerationStep.Decoration gen_step, Object Placed_ore) {
        Registry.SimpleRegister(RegistryTypes.BIOME_MODIFICATIONS, Modid, new Object[]{name, biomeTypes, gen_step, Placed_ore});
    }

    public static Object SimpleRegister(RegistryTypes type, String Modid, Object ... args) {
        VLModInfo.LOGGER.info("Registering " + type.toString().toLowerCase() + " " + String.valueOf(args[0]) + " for " + Modid);
        if (open_registeries.containsKey(Modid) && open_registeries.get(Modid).containsKey((Object)type)) {
            return open_registeries.get(Modid).get((Object)type).accept(args);
        }
        UnregisteredData data = new UnregisteredData(type, args);
        if (!ready_to_load_registeries.containsKey(Modid)) {
            ready_to_load_registeries.put(Modid, new HashSet());
            ready_to_load_registeries.get(Modid).add(data);
        } else {
            ready_to_load_registeries.get(Modid).add(data);
        }
        return data.Obj;
    }

    private static class UnregisteredData {
        public List<Object> args;
        public RegistryTypes registry_type;
        public boolean resolved;
        public Object Obj = null;

        public UnregisteredData(RegistryTypes registry_type, Object ... args) {
            this.registry_type = registry_type;
            this.args = new ArrayList<Object>();
            for (Object argdata : args) {
                this.args.add(argdata);
            }
        }
    }
}

