/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.EnergySystem;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.Vrglab.EnergySystem.EnergyStorage;
import org.Vrglab.EnergySystem.IEnergyContainer;
import org.Vrglab.EnergySystem.IEnergySupplier;
import org.Vrglab.Modloader.Types.ICallBack;

public class EnergyStorageUtils {
    public static ICallBack createStorageInstance;
    public static ICallBack extractEnergyInstance;
    public static ICallBack receiveEnergyInstance;
    public static ICallBack wrapExternalStorage;
    public static ICallBack hasExternalStorage;
    private static Map<BlockPos, IEnergyContainer> CACHED_CONTAINER;

    public static <T extends IEnergyContainer> T getCachedContainer(BlockPos pos) {
        return (T)CACHED_CONTAINER.get(pos);
    }

    public static <T extends IEnergyContainer> void cacheEnergyContainer(BlockPos pos, T container) {
        CACHED_CONTAINER.put(pos, container);
    }

    public static void removeFromCache(BlockPos pos) {
        CACHED_CONTAINER.remove(pos);
    }

    public static boolean pushEnergyTo(BlockEntity self, Level world, BlockPos blockPos, Direction dir, long amnt) {
        if (EnergyStorage.containEnergyStorage(world, blockPos.relative(dir))) {
            EnergyStorage storage = (EnergyStorage)EnergyStorage.getStorageInWorld(world, blockPos, dir);
            Object self_storage = ((IEnergySupplier)self).getEnergyStorage();
            if (storage != null && !((EnergyStorage)self_storage).isEmpty() && !storage.atMaxCapacity()) {
                storage.receiveEnergy(amnt);
                ((EnergyStorage)self_storage).extractEnergy(amnt);
                return true;
            }
        }
        return false;
    }

    public static boolean pullEnergyFrom(BlockEntity self, Level world, BlockPos blockPos, Direction dir, long amnt) {
        if (EnergyStorage.containEnergyStorage(world, blockPos.relative(dir))) {
            EnergyStorage storage = (EnergyStorage)EnergyStorage.getStorageInWorld(world, blockPos, dir);
            Object self_storage = ((IEnergySupplier)self).getEnergyStorage();
            if (storage != null && !((EnergyStorage)self_storage).atMaxCapacity() && !storage.isEmpty()) {
                storage.extractEnergy(amnt);
                ((EnergyStorage)self_storage).receiveEnergy(amnt);
                return true;
            }
        }
        return false;
    }

    static {
        CACHED_CONTAINER = new HashMap<BlockPos, IEnergyContainer>();
    }
}

