/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.Helpers;

import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.Vrglab.Utils.Utils;

public class CreativeModeTabBuilder {
    private CreativeModeTab.Builder builder;

    public static CreativeModeTabBuilder create() {
        CreativeModeTabBuilder instance = new CreativeModeTabBuilder();
        instance.builder = CreativeModeTab.builder(null, (int)-1);
        return instance;
    }

    public CreativeModeTabBuilder setDisplayText(String txt) {
        this.builder.title((Component)Component.translatable((String)txt));
        return this;
    }

    public CreativeModeTabBuilder setIcon(Object item) {
        this.builder.icon(() -> new ItemStack((ItemLike)((Item)Utils.convertToMcSafeType(item))));
        return this;
    }

    public CreativeModeTabBuilder setEntries(Object[] itementeries, Object[] blockenteries) {
        this.builder.displayItems((displayContext, entries1) -> {
            for (Object data : itementeries) {
                entries1.accept((ItemLike)((Item)Utils.convertToMcSafeType(data)));
            }
            for (Object data : blockenteries) {
                entries1.accept((ItemLike)((Block)Utils.convertToMcSafeType(data)));
            }
        });
        return this;
    }

    public CreativeModeTab build() {
        return this.builder.build();
    }
}

