/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.Modloader.Registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.Vrglab.Modloader.Types.ICallBack;
import org.Vrglab.Modloader.enumTypes.BootstrapType;

public class Bootstrapper {
    private static Map<String, Map<BootstrapType, ICallBack>> open_registeries = new HashMap<String, Map<BootstrapType, ICallBack>>();
    private static Map<String, Set<UnregisteredData>> ready_to_load_registeries = new HashMap<String, Set<UnregisteredData>>();

    public static void initBootstrapper(ICallBack _registery, BootstrapType _currentRegistryTypes, String modid) {
        if (open_registeries.containsKey(modid)) {
            open_registeries.get(modid).put(_currentRegistryTypes, _registery);
        } else {
            open_registeries.put(modid, new HashMap());
            open_registeries.get(modid).put(_currentRegistryTypes, _registery);
        }
        if (ready_to_load_registeries.containsKey(modid) && ready_to_load_registeries.get(modid).size() > 0) {
            for (UnregisteredData data : ready_to_load_registeries.get(modid)) {
                if (data.resolved || data.registry_type != _currentRegistryTypes) continue;
                data.Obj = _registery.accept(data.args.toArray());
                data.resolved = true;
            }
        }
    }

    public static Object SimpleRegister(BootstrapType type, String Modid, Object ... args) {
        if (open_registeries.containsKey(Modid) && open_registeries.get(Modid).containsKey((Object)type)) {
            return open_registeries.get(Modid).get((Object)type).accept(args);
        }
        UnregisteredData data = new UnregisteredData(type, args);
        if (!ready_to_load_registeries.containsKey(Modid)) {
            ready_to_load_registeries.put(Modid, new HashSet());
            ready_to_load_registeries.get(Modid).add(data);
        } else {
            ready_to_load_registeries.get(Modid).add(data);
        }
        return data.Obj;
    }

    private static class UnregisteredData {
        public List<Object> args;
        public BootstrapType registry_type;
        public boolean resolved;
        public Object Obj = null;

        public UnregisteredData(BootstrapType registry_type, Object ... args) {
            this.registry_type = registry_type;
            this.args = new ArrayList<Object>();
            for (Object argdata : args) {
                this.args.add(argdata);
            }
        }
    }
}

