/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.Modloader.CreationHelpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.Vrglab.Modloader.Types.ICallBack;
import org.Vrglab.Utils.VLModInfo;

public class PlacementModifierCreationHelper {
    private List<PlacementModifier> targets;
    public static ICallBack getHeightModifications;

    private PlacementModifierCreationHelper() {
    }

    public static PlacementModifierCreationHelper create() {
        PlacementModifierCreationHelper gen = new PlacementModifierCreationHelper();
        gen.targets = new ArrayList<PlacementModifier>(4);
        gen.targets.add(0, null);
        gen.targets.add(1, (PlacementModifier)InSquarePlacement.spread());
        gen.targets.add(2, null);
        gen.targets.add(3, (PlacementModifier)BiomeFilter.biome());
        return gen;
    }

    public PlacementModifierCreationHelper HeightRangePlacement(int lowest, int highest) {
        this.targets.set(2, (PlacementModifier)getHeightModifications.accept(lowest, highest));
        return this;
    }

    public PlacementModifierCreationHelper CountModifier(int count) {
        if (this.targets.get(0) != null && this.targets.get(0).getClass() == RarityFilter.class) {
            VLModInfo.LOGGER.error("Cant add Count modifier when Rarity modifier is already added");
            return this;
        }
        this.targets.set(0, (PlacementModifier)CountPlacement.of((int)count));
        return this;
    }

    public PlacementModifierCreationHelper RarityModifier(int chance) {
        if (this.targets.get(0) != null && this.targets.get(0).getClass() == CountPlacement.class) {
            VLModInfo.LOGGER.error("Cant add Rarity modifier when Count modifier is already added");
            return this;
        }
        this.targets.set(0, (PlacementModifier)RarityFilter.onAverageOnceEvery((int)chance));
        return this;
    }

    public List<PlacementModifier> build() {
        return this.targets;
    }
}

