/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.EnergySystem;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.Vrglab.EnergySystem.EnergyStorageUtils;
import org.Vrglab.EnergySystem.IEnergyContainer;
import org.Vrglab.EnergySystem.IEnergySupplier;
import org.Vrglab.Modloader.CreationHelpers.TypeTransformer;
import org.Vrglab.Modloader.Types.ICallBackVoidNoArg;

public class EnergyStorage
implements IEnergyContainer {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    public ICallBackVoidNoArg makeDirty;
    protected Object actualEnergyInstance;
    protected Object blockEntity;

    public static <T extends EnergyStorage> T createStorage(Class<T> clazz, long capacity) {
        try {
            return (T)((EnergyStorage)clazz.getConstructor(Long.TYPE).newInstance(capacity));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create EnergyStorage instance", e);
        }
    }

    public static <T extends EnergyStorage> T createStorage(Class<T> clazz, long capacity, long maxTransfer) {
        try {
            return (T)((EnergyStorage)clazz.getConstructor(Long.TYPE, Long.TYPE).newInstance(capacity, maxTransfer));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create EnergyStorage instance", e);
        }
    }

    public static <T extends EnergyStorage> T createStorage(Class<T> clazz, long capacity, long maxTransfer, long maxExtract) {
        try {
            return (T)((EnergyStorage)clazz.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE).newInstance(capacity, maxTransfer, maxExtract));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create EnergyStorage instance", e);
        }
    }

    public static <T extends EnergyStorage> T createStorage(Class<T> clazz, long capacity, long maxTransfer, long maxExtract, long energy) {
        try {
            return (T)((EnergyStorage)clazz.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE).newInstance(capacity, maxTransfer, maxExtract, energy));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create EnergyStorage instance", e);
        }
    }

    public static EnergyStorage createStorage(long capacity) {
        return EnergyStorage.createStorage(EnergyStorage.class, capacity);
    }

    public static EnergyStorage createStorage(long capacity, long maxTransfer) {
        return EnergyStorage.createStorage(EnergyStorage.class, capacity, maxTransfer);
    }

    public static EnergyStorage createStorage(long capacity, long maxTransfer, long maxExtract) {
        return EnergyStorage.createStorage(EnergyStorage.class, capacity, maxTransfer, maxExtract);
    }

    public static EnergyStorage createStorage(long capacity, long maxTransfer, long maxExtract, long energy) {
        return EnergyStorage.createStorage(EnergyStorage.class, capacity, maxTransfer, maxExtract, energy);
    }

    public static IEnergyContainer getStorageInWorld(class_1937 world, class_2338 blockPos, class_2350 facing) {
        EnergyStorage storage;
        block8: {
            storage = null;
            class_2586 entity = world.method_8321(blockPos.method_10093(facing));
            if (EnergyStorage.containEnergyStorage(entity)) {
                try {
                    if (entity != null && entity instanceof IEnergySupplier) {
                        storage = (EnergyStorage)((IEnergySupplier)entity).getEnergyStorage();
                        break block8;
                    }
                    if (!((Boolean)EnergyStorageUtils.hasExternalStorage.accept(entity)).booleanValue()) break block8;
                    if (EnergyStorageUtils.getCachedContainer(blockPos.method_10093(facing)) != null) {
                        try {
                            storage = (EnergyStorage)EnergyStorageUtils.getCachedContainer(blockPos.method_10093(facing));
                            if (((class_2586)((EnergyStorage)storage).blockEntity).method_11015()) {
                                EnergyStorageUtils.removeFromCache(blockPos.method_10093(facing));
                                throw new RuntimeException("Accessed Storage is removed");
                            }
                            break block8;
                        }
                        catch (Throwable t) {
                            storage = (EnergyStorage)EnergyStorageUtils.wrapExternalStorage.accept(world, blockPos, facing, entity);
                            EnergyStorageUtils.cacheEnergyContainer(blockPos.method_10093(facing), storage);
                        }
                        break block8;
                    }
                    storage = (EnergyStorage)EnergyStorageUtils.wrapExternalStorage.accept(world, blockPos, facing, entity);
                    EnergyStorageUtils.cacheEnergyContainer(blockPos.method_10093(facing), storage);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return storage;
    }

    public static boolean containEnergyStorage(class_1937 world, class_2338 blockPos) {
        class_2586 entity = world.method_8321(blockPos);
        return EnergyStorage.containEnergyStorage(entity);
    }

    public static boolean containEnergyStorage(class_2586 entity) {
        if (entity != null && entity instanceof IEnergySupplier || ((Boolean)EnergyStorageUtils.hasExternalStorage.accept(entity)).booleanValue()) {
            try {
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public EnergyStorage(long capacity) {
        this(capacity, capacity, capacity, 0L);
    }

    public EnergyStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0L);
    }

    public EnergyStorage(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, 0L);
    }

    public EnergyStorage(long capacity, long maxReceive, long maxExtract, long energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0L, Math.min(capacity, energy));
        this.actualEnergyInstance = EnergyStorageUtils.createStorageInstance.accept(capacity, maxReceive, maxExtract, energy, this, this.blockEntity);
    }

    public EnergyStorage(Object instance, long capacity, long maxReceive, long maxExtract, long energy) {
        this(capacity, maxReceive, maxExtract, energy);
        this.actualEnergyInstance = instance;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        this.energy += Long.valueOf(EnergyStorageUtils.receiveEnergyInstance.accept(this.actualEnergyInstance, maxReceive, simulate).toString()).longValue();
        return this.energy;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        this.energy -= Long.valueOf(EnergyStorageUtils.extractEnergyInstance.accept(this.actualEnergyInstance, maxExtract, simulate).toString()).longValue();
        return this.energy;
    }

    @Override
    public long receiveEnergy(long maxReceive) {
        return this.receiveEnergy(maxReceive, false);
    }

    @Override
    public long extractEnergy(long maxExtract) {
        return this.extractEnergy(maxExtract, false);
    }

    public EnergyStorage setBlockEntityType(Object blockEntity) {
        this.blockEntity = TypeTransformer.ObjectToType.accept(blockEntity);
        return this;
    }

    public EnergyStorage setMakeDirtyFunction(ICallBackVoidNoArg makeDirty) {
        this.makeDirty = makeDirty;
        return this;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0L;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0L;
    }

    public boolean isEmpty() {
        return this.energy == 0L;
    }

    public boolean atMaxCapacity() {
        return this.energy == this.capacity;
    }
}

