/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.Modloader.Registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1914;
import net.minecraft.class_2248;
import net.minecraft.class_2893;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import org.Vrglab.Modloader.Types.IBlockEntityLoaderFunction;
import org.Vrglab.Modloader.Types.ICallBack;
import org.Vrglab.Modloader.Types.IScreenHandledCreationFunction;
import org.Vrglab.Modloader.Types.IScreenHandlerTypeCreationFunction;
import org.Vrglab.Modloader.enumTypes.IRegistryType;
import org.Vrglab.Modloader.enumTypes.RegistryTypes;
import org.Vrglab.Modloader.enumTypes.VinillaBiomeTypes;
import org.Vrglab.Screen.ScreenHandler;
import org.Vrglab.Utils.VLModInfo;

public class Registry {
    private static Map<String, Map<UUID, ICallBack>> open_registeries = new HashMap<String, Map<UUID, ICallBack>>();
    private static Map<String, Set<UnregisteredData>> ready_to_load_registeries = new HashMap<String, Set<UnregisteredData>>();

    public static void initRegistry(ICallBack _registery, UUID _currentRegistryTypes, String modid) {
        if (open_registeries.containsKey(modid)) {
            open_registeries.get(modid).put(_currentRegistryTypes, _registery);
        } else {
            open_registeries.put(modid, new HashMap());
            open_registeries.get(modid).put(_currentRegistryTypes, _registery);
        }
        if (ready_to_load_registeries.containsKey(modid) && ready_to_load_registeries.get(modid).size() > 0) {
            for (UnregisteredData data : ready_to_load_registeries.get(modid)) {
                if (data.resolved || data.registry_type != _currentRegistryTypes) continue;
                data.Obj = _registery.accept(data.args.toArray());
                data.resolved = true;
            }
        }
    }

    public static void initRegistry(ICallBack _registery, IRegistryType _currentRegistryTypes, String modid) {
        Registry.initRegistry(_registery, _currentRegistryTypes.getTypeId(), modid);
    }

    public static void ForgeEventResolver(Object eventData, ICallBack resolver, IRegistryType ResolveTypeOf, String modid) {
        Registry.ForgeEventResolver(eventData, resolver, ResolveTypeOf.getTypeId(), modid);
    }

    public static void ForgeEventResolver(Object eventData, ICallBack resolver, UUID ResolveTypeOf, String modid) {
        if (ready_to_load_registeries.containsKey(modid) && ready_to_load_registeries.get(modid).size() > 0) {
            for (UnregisteredData data : ready_to_load_registeries.get(modid)) {
                if (data.resolved || data.registry_type != ResolveTypeOf) continue;
                data.Obj = resolver.accept(data.args.toArray(), eventData);
            }
        }
    }

    public static Object RegisterItem(String name, String Modid, Supplier aNew) {
        return Registry.SimpleRegister(RegistryTypes.ITEM, Modid, name, aNew);
    }

    public static Object RegisterBlock(String name, String Modid, Supplier aNew, Supplier<class_1792.class_1793> settings) {
        return Registry.SimpleRegister(RegistryTypes.BLOCK, Modid, name, aNew, settings);
    }

    public static Object RegisterBlockEntityType(String name, String Modid, IBlockEntityLoaderFunction aNew, Object block) {
        return Registry.SimpleRegister(RegistryTypes.BLOCK_ENTITY_TYPE, Modid, name, aNew, block);
    }

    public static Object RegisterScreenHandlerType(String name, String Modid, IScreenHandlerTypeCreationFunction aNew) {
        return Registry.SimpleRegister(RegistryTypes.SCREEN_HANDLER_TYPE, Modid, name, aNew);
    }

    public static <T extends ScreenHandler, U extends class_437> void RegisterHandledScreen(String name, String Modid, Object handlerType, IScreenHandledCreationFunction<T, U> aNew) {
        Registry.SimpleRegister(RegistryTypes.HANDLED_SCREEN, Modid, name, handlerType, aNew);
    }

    public static Object RegisterItemlessBlock(String name, String Modid, Supplier aNew) {
        return Registry.SimpleRegister(RegistryTypes.ITEMLESS_BLOCK, Modid, name, aNew);
    }

    public static Object RegisterPOI(String name, String Modid, Object block, int tickcount, int searchdistance) {
        return Registry.SimpleRegister(RegistryTypes.POI, Modid, name, tickcount, searchdistance, block);
    }

    public static Object RegisterProfession(String name, String Modid, String aNew, class_1792[] itemImmutableSet, class_2248[] blockImmutableSet, class_3414 sound) {
        return Registry.SimpleRegister(RegistryTypes.PROFESSION, Modid, name, aNew, itemImmutableSet, blockImmutableSet, sound);
    }

    public static void RegisterVillagerTrade(String name, String Modid, Object profession, int level, class_1914 ... trades) {
        Registry.SimpleRegister(RegistryTypes.TRADE, Modid, name, profession, level, trades);
    }

    public static Object RegisterOreConfiguredFeature(String name, String Modid, Supplier<List<class_3124.class_5876>> targets, int size) {
        return Registry.SimpleRegister(RegistryTypes.CONFIGURED_FEAT_ORE, Modid, name, class_3031.field_13517, targets, size);
    }

    public static Object RegisterPlacedFeature(String name, String Modid, Object configured_feat, Object data) {
        return Registry.SimpleRegister(RegistryTypes.PLACED_FEAT, Modid, name, configured_feat, data);
    }

    public static void AddBiomeModification(String name, String Modid, VinillaBiomeTypes biomeTypes, class_2893.class_2895 gen_step, Object Placed_ore) {
        Registry.SimpleRegister(RegistryTypes.BIOME_MODIFICATIONS, Modid, new Object[]{name, biomeTypes, gen_step, Placed_ore});
    }

    public static Object RegisterRecipeSerializer(String name, String Modid, class_1865 serializer_instance) {
        return Registry.SimpleRegister(RegistryTypes.RECIPE_SERIALIZER, Modid, name, serializer_instance);
    }

    public static Object RegisterRecipeType(String name, String Modid, class_3956 type_instance) {
        return Registry.SimpleRegister(RegistryTypes.RECIPE_TYPE, Modid, name, type_instance);
    }

    public static <T extends class_1761> Object RegisterCreativeModeTab(String name, String Modid, T tab) {
        return Registry.SimpleRegister(RegistryTypes.CREATIVE_MODE_TAB, Modid, name, tab);
    }

    public static Object SimpleRegister(IRegistryType type, String Modid, Object ... args) {
        return Registry.SimpleRegister(type.getTypeId(), Modid, args);
    }

    public static Object SimpleRegister(UUID type, String Modid, Object ... args) {
        VLModInfo.LOGGER.info("Registering " + String.valueOf(type).toLowerCase() + " " + String.valueOf(args[0]) + " for " + Modid);
        if (open_registeries.containsKey(Modid) && open_registeries.get(Modid).containsKey(type)) {
            return open_registeries.get(Modid).get(type).accept(args);
        }
        UnregisteredData data = new UnregisteredData(type, args);
        if (!ready_to_load_registeries.containsKey(Modid)) {
            ready_to_load_registeries.put(Modid, new HashSet());
            ready_to_load_registeries.get(Modid).add(data);
        } else {
            ready_to_load_registeries.get(Modid).add(data);
        }
        return data.Obj;
    }

    private static class UnregisteredData {
        public List<Object> args;
        public UUID registry_type;
        public boolean resolved;
        public Object Obj = null;

        public UnregisteredData(UUID registry_type, Object ... args) {
            this.registry_type = registry_type;
            this.args = new ArrayList<Object>();
            for (Object argdata : args) {
                this.args.add(argdata);
            }
        }
    }
}

