/*
 * Decompiled with CFR 0.152.
 */
package org.Vrglab.AutoRegisteration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.function.Supplier;
import org.Vrglab.AutoRegisteration.Annotations.InitializableClass;
import org.Vrglab.AutoRegisteration.Annotations.RegisterBlock;
import org.Vrglab.AutoRegisteration.Annotations.RegisterBlockEntityType;
import org.Vrglab.AutoRegisteration.Annotations.RegisterItem;
import org.Vrglab.AutoRegisteration.Annotations.RegisterItemlessBlock;
import org.Vrglab.AutoRegisteration.Objects.AutoRegisteryObject;
import org.Vrglab.AutoRegisteration.Objects.RegistryBlock;
import org.Vrglab.AutoRegisteration.Objects.RegistryBlockEntityType;
import org.Vrglab.AutoRegisteration.Objects.RegistryItem;
import org.Vrglab.AutoRegisteration.Objects.RegistryItemlessBlock;
import org.Vrglab.Modloader.Registration.Registry;
import org.Vrglab.Modloader.Types.IBlockEntityLoaderFunction;
import org.Vrglab.Modloader.Types.ICallBack;
import org.Vrglab.Utils.VLModInfo;
import org.jetbrains.annotations.ApiStatus;

public class AutoRegistryLoader {
    static ClassLoader loader = null;
    @ApiStatus.Internal
    public static ICallBack collectAnnotatedTypesForMod;
    @ApiStatus.Internal
    public static ICallBack collectAnnotatedFieldsForMod;
    @ApiStatus.Internal
    public static ICallBack entityTypeBlockSelector;

    public static void LoadAllInPackage(String packageName, String modid) {
        AutoRegistryLoader.loadItemsInPackage(packageName, modid);
        AutoRegistryLoader.loadBlocksInPackage(packageName, modid);
        AutoRegistryLoader.loadItemlessBlocksInPackage(packageName, modid);
        AutoRegistryLoader.loadBlockEntityTypesInPackage(packageName, modid);
        AutoRegistryLoader.callInitsInPackage(packageName, modid);
    }

    public static void loadItemsInPackage(String packageName, String modId) {
        AutoRegistryLoader.LoadingResolver(packageName, modId, RegisterItem.class, args -> {
            RegistryItem rg = (RegistryItem)args[0];
            RegisterItem rt = (RegisterItem)args[1];
            Object return_val = Registry.RegisterItem(rt.ItemName(), modId, rg.getSupplier());
            rg.setRegistryData(return_val);
            return return_val;
        });
    }

    public static void loadBlocksInPackage(String packageName, String modId) {
        AutoRegistryLoader.LoadingResolver(packageName, modId, RegisterBlock.class, args -> {
            RegistryBlock rg = (RegistryBlock)args[0];
            RegisterBlock rt = (RegisterBlock)args[1];
            Object return_val = Registry.RegisterBlock(rt.Name(), modId, rg.getSupplier(), (Supplier)rg.getArgs().get("item.settings"));
            rg.setRegistryData(return_val);
            return return_val;
        });
    }

    public static void loadItemlessBlocksInPackage(String packageName, String modId) {
        AutoRegistryLoader.LoadingResolver(packageName, modId, RegisterItemlessBlock.class, args -> {
            RegistryItemlessBlock rg = (RegistryItemlessBlock)args[0];
            RegisterItemlessBlock rt = (RegisterItemlessBlock)args[1];
            Object return_val = Registry.RegisterItemlessBlock(rt.Name(), modId, rg.getSupplier());
            rg.setRegistryData(return_val);
            return return_val;
        });
    }

    public static void loadBlockEntityTypesInPackage(String packageName, String modId) {
        AutoRegistryLoader.LoadingResolver(packageName, modId, RegisterBlockEntityType.class, args -> {
            RegistryBlockEntityType rg = (RegistryBlockEntityType)args[0];
            RegisterBlockEntityType rt = (RegisterBlockEntityType)args[1];
            Object return_val = Registry.RegisterBlockEntityType(rt.Name(), modId, (IBlockEntityLoaderFunction)rg.getArgs().get("new"), rg.getArgs().get("block") instanceof RegistryBlock ? entityTypeBlockSelector.accept(rg) : rg.getArgs().get("block"));
            rg.setRegistryData(return_val);
            return return_val;
        });
    }

    private static void callInitsInPackage(String packageName, String modId) {
        Set<Class> annotatedType = AutoRegistryLoader.getTypesAnnotatedIn(InitializableClass.class, packageName, modId);
        annotatedType.forEach(type -> {
            try {
                type.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                VLModInfo.LOGGER.error(e.getMessage());
            }
        });
    }

    private static <T extends Annotation> void LoadingResolver(String packageName, String modId, Class<T> annotation, ICallBack Resolver) {
        Set<Field> annotatedFields = AutoRegistryLoader.getFieldsAnnotatedIn(annotation, packageName, modId);
        annotatedFields.forEach(field -> {
            Object anno = field.getAnnotation(annotation);
            try {
                AutoRegisteryObject rg = (AutoRegisteryObject)field.get(null);
                if (rg.getModid().equals(modId)) {
                    Resolver.accept(rg, anno);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Set<Field> getFieldsAnnotatedIn(Class annotation, String packageName, String modid) {
        return (Set)collectAnnotatedFieldsForMod.accept(packageName, annotation, modid);
    }

    private static Set<Class> getTypesAnnotatedIn(Class annotation, String packageName, String modid) {
        return (Set)collectAnnotatedTypesForMod.accept(packageName, annotation, modid);
    }
}

